********************************************************************************
******************               psiM and psiF                ******************  
********************************************************************************


**————————————————————————————————————2002————————————————————————————————————**
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\CHIPs\2002\2002 DS0001[Urban Individual Income, Consumption, and Employment]\21741-0001-Data.dta"
*CHIP 2002 urban individual-level data DS0001 //

bys PCODE: egen hsize=max(P102)
order hsize, after(P102)

*keep if P106>=20 & P106<=30
*tab P112 if P105==1
/*
psiM=0.4322
                      Educational level |      Freq.     Percent        Cum.
----------------------------------------+-----------------------------------
                                      0 |          4        0.35        0.35
                         Never schooled |          6        0.52        0.87
                      Elementary school |          7        0.61        1.49
                   Junior middle school |        146       12.77       14.26
Senior middle school (including profess |        317       27.73       41.99
             Technical secondary school |        169       14.79       56.78
                         Junior college |        291       25.46       82.24
                     College/university |        195       17.06       99.30
                               Graduate |          8        0.70      100.00
----------------------------------------+-----------------------------------
                                  Total |      1,143      100.00
*/

*tab P112 if P105==2
/* psiF=0.4764
                      Educational level |      Freq.     Percent        Cum.
----------------------------------------+-----------------------------------
                                      0 |          5        0.39        0.39
                         Never schooled |          6        0.46        0.85
                      Elementary school |         18        1.39        2.24
                   Junior middle school |        175       13.51       15.75
Senior middle school (including profess |        255       19.69       35.44
             Technical secondary school |        219       16.91       52.36
                         Junior college |        404       31.20       83.55
                     College/university |        207       15.98       99.54
                               Graduate |          6        0.46      100.00
----------------------------------------+-----------------------------------
                                  Total |      1,295      100.00
*/

*keep if P106>=20 & P106<=35
*tab P112 if P105==1
/*
psiM=0.4304
                      Educational level |      Freq.     Percent        Cum.
----------------------------------------+-----------------------------------
                                      0 |          4        0.21        0.21
                         Never schooled |          9        0.46        0.67
     Classes for eliminating illiteracy |          1        0.05        0.72
                      Elementary school |         19        0.98        1.70
                   Junior middle school |        301       15.52       17.22
Senior middle school (including profess |        527       27.16       44.38
             Technical secondary school |        244       12.58       56.96
                         Junior college |        498       25.67       82.63
                     College/university |        322       16.60       99.23
                               Graduate |         15        0.77      100.00
----------------------------------------+-----------------------------------
                                  Total |      1,940      100.00
*/
*tab P112 if P105==2
/*  psiF=0.4286
                    Educational level |      Freq.     Percent        Cum.
----------------------------------------+-----------------------------------
                                      0 |          5        0.23        0.23
                         Never schooled |          8        0.36        0.59
     Classes for eliminating illiteracy |          1        0.05        0.63
                      Elementary school |         37        1.67        2.31
                   Junior middle school |        406       18.35       20.66
Senior middle school (including profess |        473       21.38       42.04
             Technical secondary school |        334       15.10       57.14
                         Junior college |        647       29.25       86.39
                     College/university |        289       13.07       99.46
                               Graduate |         12        0.54      100.00
----------------------------------------+-----------------------------------
                                  Total |      2,212      100.00
*/


**————————————————————————————————————2007————————————————————————————————————**
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\CHIPs\2007 (RUMiC 2008)\CHIP2007_or_RUMiC2008_urban_data_20151222\UHS_w1_abc.dta"

gen age=2007-(a05_1), after(a05_1)

rename hhcode PCODE

bys PCODE: egen hsize=max(a02)
order hsize, after (a02)

/*
keep if age>=20 & age<=30
tab b02 if a04==1
psiM=0.5882
        had |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          2        0.23        0.23
          2 |          1        0.11        0.34
          3 |          8        0.91        1.25
          4 |         58        6.60        7.85
          5 |        154       17.52       25.37
          6 |        138       15.70       41.07
          7 |        294       33.45       74.52
          8 |        208       23.66       98.18
          9 |         15        1.71       99.89
         18 |          1        0.11      100.00
------------+-----------------------------------
      Total |        879      100.00

tab b02 if a04==2
psiF=0.5930
        had |      Freq.     Percent        Cum.
------------+-----------------------------------
          2 |          1        0.10        0.10
          3 |          7        0.71        0.81
          4 |         87        8.81        9.62
          5 |        136       13.77       23.38
          6 |        170       17.21       40.59
          7 |        341       34.51       75.10
          8 |        225       22.77       97.87
          9 |         20        2.02       99.90
         29 |          1        0.10      100.00
------------+-----------------------------------
      Total |        988      100.00

*1.未上过学 2.扫盲班 3.小学 4.初中 5.高中 6.中专 7.大学专科 8.大学本科 9.研究生

keep if age>=20 & age<=35
tab b02 if a04==1
psiM=0.5683
        had |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          3        0.21        0.21
          2 |          2        0.14        0.35
          3 |         17        1.18        1.53
          4 |        129        8.95       10.48
          5 |        265       18.39       28.87
          6 |        205       14.23       43.10
          7 |        443       30.74       73.84
          8 |        329       22.83       96.67
          9 |         47        3.26       99.93
         18 |          1        0.07      100.00
------------+-----------------------------------
      Total |      1,441      100.00

tab b02 if a04==2
psiF=0.5389
        had |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          4        0.24        0.24
          2 |          3        0.18        0.43
          3 |         18        1.09        1.52
          4 |        213       12.96       14.48
          5 |        282       17.15       31.63
          6 |        237       14.42       46.05
          7 |        522       31.75       77.80
          8 |        328       19.95       97.75
          9 |         36        2.19       99.94
         29 |          1        0.06      100.00
------------+-----------------------------------
      Total |      1,644      100.00
*/

**————————————————————————————————————2013————————————————————————————————————**
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\CHIPs\2013\CHIP2013_urban_personal information\CHIP2013_urban_person.dta" 		

gen age=2013-(a04_1), after(a04_1)

rename hhcode PCODE
bys PCODE: egen hsize=max(person)
order hsize, after (person)

/*
keep if age>=20 & age<=30
tab a13_1 if a03==1

/*
①未上过学（包括识字班等非正规的教育）
②小学
③初中
④高中
⑤职高/技校
⑥中专
⑦大专
⑧大学本科
⑨研究生 */

psiM=0.5509
      a13_1 |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          6        0.45        0.45
          2 |         17        1.26        1.71
          3 |        200       14.87       16.58
          4 |        160       11.90       28.48
          5 |        113        8.40       36.88
          6 |        107        7.96       44.83
          7 |        347       25.80       70.63
          8 |        355       26.39       97.03
          9 |         39        2.90       99.93
         19 |          1        0.07      100.00
------------+-----------------------------------
      Total |      1,345      100.00

tab a13_1 if a03==2

psiF=0.5999
      a13_1 |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          1        0.07        0.07
          2 |         23        1.63        1.70
          3 |        207       14.66       16.36
          4 |        169       11.97       28.33
          5 |         50        3.54       31.87
          6 |        115        8.14       40.01
          7 |        363       25.71       65.72
          8 |        436       30.88       96.60
          9 |         48        3.40      100.00
------------+-----------------------------------
      Total |      1,412      100.00

keep if age>=20 & age<=35
tab a13_1 if a03==1
psiM=0.5408
      a13_1 |      Freq.     Percent        Cum.
------------+-----------------------------------
          1 |          7        0.34        0.34
          2 |         26        1.25        1.59
          3 |        326       15.67       17.26
          4 |        270       12.98       30.24
          5 |        154        7.40       37.64
          6 |        171        8.22       45.87
          7 |        502       24.13       70.00
          8 |        545       26.20       96.20
          9 |         78        3.75       99.95
         19 |          1        0.05      100.00
------------+-----------------------------------
      Total |      2,080      100.00

tab a13_1 if a03==2
psiF=0.5574
      a13_1 |      Freq.     Percent        Cum.        
------------+-----------------------------------
          1 |          2        0.09        0.09
          2 |         37        1.68        1.77
          3 |        368       16.72       18.49
          4 |        279       12.68       31.17
          5 |         87        3.95       35.12
          6 |        201        9.13       44.25
          7 |        549       24.94       69.20
          8 |        598       27.17       96.37
          9 |         80        3.63      100.00
------------+-----------------------------------
      Total |      2,201      100.00
*/

/* 20<=age<=30
        2002      2007      2013        mean            SE
psiM   0.4322    0.5882    0.5509      0.5237667      0.0470325
psiF   0.4764    0.5930    0.5999      0.5564333      0.0400662

input psiM psiF year
0.4322 0.4764 2002
0.5882 0.5930 2007
0.5509 0.5999 2013
end

   20<=age<=35
        2002      2007      2013        mean            SE
psiM   0.4304    0.5683    0.5408      0.5131667      0.0421379
psiF   0.4286    0.5389    0.5574      0.5083         0.0402063  

input psiM psiF year
0.4304 0.4286 2002
0.5683 0.5389 2007
0.5408 0.5574 2013
end
*/

* share of marriaged 


***********************               wage                 *********************
********************************************************************************
**————————————————————————————————————2013————————————————————————————————————**
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\CHIPs\2013\CHIP2013_urban_personal information\CHIP2013_urban_person.dta" 		

gen age=2013-(a04_1), after(a04_1)

rename hhcode PCODE
bys PCODE: egen hsize=max(person)
order hsize, after (person)

rename a13_1 edu
			 
keep if age>=25 & age<=55 //keep individual information for age between 20 to 30//
keep if c05_1>0
sort age
tab a03 //gender//
tab age if a03==1

sum c05_1

tab edu
drop if edu>9

bys age: egen wU_m=mean(c05_1) if edu<=6 & a03==1
bys age: egen wU_f=mean(c05_1) if edu<=6 & a03==2
bys age: egen wS_m=mean(c05_1) if edu>=7 & a03==1
bys age: egen wS_f=mean(c05_1) if edu>=7 & a03==2

order PCODE person hsize coun a02 a03 a04_1 age wU_m wU_f wS_m wS_f edu c05_1
tab wU_m

collapse wU_m wU_f wS_m wS_f, by(age)
tab wU_m

line wU_m age
*replace wS_f = . in 29

gen t=_n
gen beta=0.96^(t)

gen wum1=wU_m*beta
gen wsm1=wS_m*beta
gen wuf1=wU_f*beta
gen wsf1=wS_f*beta

egen wum=sum(wum1)
egen wsm=sum(wsm1)
egen wuf=sum(wuf1)
egen wsf=sum(wsf1)

gen rsfuf=wsf/wuf
gen rumuf=wum/wuf
gen rsmuf=wsm/wuf

/* age (25,55)
wU_f = 1
wU_m = 1.350652
wS_f = 1.608132
wS_m = 2.003164 */


*********************            5 yrs interval          ***********************
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\CHIPs\2013\CHIP2013_urban_personal information\CHIP2013_urban_person.dta" 		

gen age=2013-(a04_1), after(a04_1)

rename hhcode PCODE
bys PCODE: egen hsize=max(person)
order hsize, after (person)
		 
keep if age>=25 & age<=60 //keep individual information for age between 20 to 30//
keep if c05_1>0
sort age
rename a13_1 edu
rename c05_1 income
rename a03 sex

tab sex //gender//
tab age if sex==1

sum income
tab income
tab edu
drop if edu>9

*forvalue i`i' 
gen i1=1 if age>=25 & age<=30
gen i2=2 if age>30 & age<=35
gen i3=3 if age>35 & age<=40
gen i4=4 if age>40 & age<=45
gen i5=5 if age>45 & age<=50
gen i6=6 if age>50 & age<=55
gen i7=7 if age>55 & age<=60

egen interval =rowtotal(i1 i2 i3 i4 i5 i6 i7)
order interval,after(age)

bys interval: egen wU_m=mean(income) if edu<=6 & sex==1
bys interval: egen wU_f=mean(income) if edu<=6 & sex==2
bys interval: egen wS_m=mean(income) if edu>=7 & sex==1
bys interval: egen wS_f=mean(income) if edu>=7 & sex==2

*order PCODE person hsize coun a02 a03 a04_1 age wU_m wU_f wS_m wS_f edu c05_1
tab wU_m

collapse wU_m wU_f wS_m wS_f, by(interval)
tab wU_m

gen t=_n
gen beta=(0.96^5)^(t)

gen wum1=wU_m*beta
gen wsm1=wS_m*beta
gen wuf1=wU_f*beta
gen wsf1=wS_f*beta

egen wum=sum(wum1)
egen wsm=sum(wsm1)
egen wuf=sum(wuf1)
egen wsf=sum(wsf1)

gen rsfuf=wsf/wuf
gen rumuf=wum/wuf
gen rsmuf=wsm/wuf

/* age [25,60]
wU_f = 1
wU_m = 1.359217
wS_f = 1.616177
wS_m = 2.057893 */


******************            regression prediction          *******************
clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\2013\CHIP2013_urban_personal information\CHIP2013_urban_person.dta" 		

gen age=2013-(a04_1), after(a04_1)

rename hhcode PCODE
bys PCODE: egen hsize=max(person)
order hsize, after (person)
		 
keep if age>=25 & age<=60 

















duplicates t PCODE,g(tag)
order tag, after(PCODE)
tab tag
drop if tag==0 //delete not pairs//

bys PCODE: egen spouse=sum(a02)
order spouse, after(a02)
tab spouse //spouse==6,9 为兄妹, spouse==13, 2儿子1儿媳，spouse==20, 两对夫妇//
*spouse==20 could be break
keep if spouse==3 | spouse==10


	******Individual information ******
bys PCODE: egen hage=max(age*(a03==1))                           /* husband age*/
bys PCODE: egen wage=max(age*(a03==2))                           /* wife age */
bys PCODE: egen hedu=max(a13_2*(a03==1))                           /* husband year of schooling*/  
bys PCODE: egen wedu=max(a13_2*(a03==2))                           /* wife year of schooling*/
bys PCODE: egen hedulevel=max(a13_1*(a03==1))
bys PCODE: egen wedulevel=max(a13_1*(a03==2))

gen work=1               //work //
replace work=0 if a19>1 //status work or not//
bys PCODE: egen hwork=max(work*(a03==1))
bys PCODE: egen wwork=max(work*(a03==2)) //work status of husband or wife//

gen hukou=1 //non-agriculture//
replace hukou=0 if a10==1
bys PCODE: egen hhukou=max(hukou*(a03==1))
bys PCODE: egen whukou=max(hukou*(a03==2)) //hukou status of spouses//

gen minor=1 //yes //
replace minor=0 if a06<2
bys PCODE: egen hmin=max(minor*(a03==1))
bys PCODE: egen wmin=max(minor*(a03==2)) //minority//

/*
bys PCODE: egen hgrades=max(P115*(P105==1))
bys PCODE: egen wgrades=max(P115*(P105==2)) //grades of individual//
*/
*rename P201 INCOME02
/*
global yr "98 99 00 01 02"
foreach y in $yr {
	bys PCODE: egen hinc`y'=max(INCOME`y'*(P105==1))
	bys PCODE: egen winc`y'=max(INCOME`y'*(P105==2))
} 
// individual income in previous 5 years //


forvalues i=1 (1) 6 {
	gen t`i'=INCOME`i'
} 
*/

rename coun code
rename PCODE pcode

collapse (first) code hage wage hedu wedu hedulevel wedulevel hwork wwork hhukou ///
whukou hmin wmin, by(pcode)

gen hage2=hage*hage
gen wage2=wage*wage
gen year=2013

drop if hedu==0 | wedu==0 | hedu==. | wedu==.

tostring code, gen(p)
gen prefect=substr(p,1,4)
destring prefect, force replace
gen pv=substr(p,1,2)
destring pv, force replace
order prefect pv year, after(code)
drop p

save temp13, replace			 
